<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for messages
*
* @package	vbmail
*/
class vBMail_DataManager_Message extends vB_DataManager
{
	/**
	* Array of recognised and required fields for messages, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'messageid' 	=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD, 	'verify_nonzero'),
		'fromaddress' 	=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_email'),
		'subject' 		=> array(TYPE_STR, 		REQ_NO),
		'headers' 		=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'body' 			=> array(TYPE_STR, 		REQ_NO),
		'dateline' 		=> array(TYPE_UNIXTIME, REQ_YES),
		'bounce' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbmail_message';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('messageid = %1$d', 'messageid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBMail_DataManager_Message(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_messagedata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the message
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		/*
		// Check for existing message of this name
		if ($existing = $this->registry->db->query_first_slave("
			SELECT `title`
			FROM `" . TABLE_PREFIX . "dbtech_vbmail_message`
			WHERE `title` = " . $this->registry->db->sql_prepare($title) . "
				" . ($this->existing['messageid'] ? "AND `messageid` != " . $this->registry->db->sql_prepare($this->existing['messageid']) : '') . "
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_vbmail_x_already_exists_y', $vbphrase['dbtech_vbmail_message'], $title);
			return false;
		}
		*/

		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}
	
	/**
	* Verifies that an email address is valid
	*
	* @param	string	Email address
	*
	* @return	boolean
	*/
	function verify_email(&$email)
	{
		return (is_valid_email($email) OR $email == '');
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_messagedata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_messagedata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_messagedata_postsave')) ? eval($hook) : false;

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_messagedata_delete')) ? eval($hook) : false;
		
		return true;
	}
}